//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |20.VDD
02.P00/XIN.............02|               |19.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-16    |18.P41/AIN1/KWI1
04.P10/RESETB..........04|               |17.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |16.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-16   |15.P44/AIN4/KWI4       
07.P91/RX/TX...........07|               |14.P74/DVOB/AIN8/SI/KWI13
08.P72/TCA0/PPGA0B.....08|	             |13.P76/INT3/SCLK/KWI15
09.P82/TC04/PWM04B.....09|               |12.P70/TC00/PWM00B
10.P83/TC05/PWM05B.....10|	             |11.P75/INT2/SO/KWI14
.........................-----------------............................
*********************************************************************/
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

#include "ADC.h"

//-- header guards --//
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif


//-- Define IO port --//
#define	look_SDA		P9DR.bit.b0
#define	look_SCL		P9DR.bit.b1



//-- function definition --//
void delay_times(uchar tBase, uint x);
void look_data(uchar data);


const uchar t_1ms   = 0;
const uchar t_100us = 1;
const uchar t_6u    = 2;	//HIRC: 8MHz, CGCR/4
const uchar t_3u    = 3;	//HIRC:16MHz, CGCR/4


uint  ADC_Code_READ;
ulong ADC_VOLTAGE;
uchar data2Port[2];

uint  vref_l, vref_h;
ulong iReal_Vref2V, adc_value, adc_GND;



void main()
{
	uchar iloop;

	WDCDR.byte = 0x4e;			// clear wdt
//	P90/P91(SDA/SCL) output for ADC result by IO_i2c
	P9DR.bit.b0 = 1;
	P9CR.bit.b0 = 1;
	P9DR.bit.b1 = 1;
	P9CR.bit.b1 = 1;

	P8DR.bit.b2 = 0;
	P8CR.bit.b2 = 1;
	P8DR.bit.b3 = 0;
	P8CR.bit.b3 = 1;

//-----------------------------------
//	perform this procedure once to get the actual value of internal Vref 2V
//	MQ6812:readout value is the actual value of internal Vref 2V multiplied by 1024 and its unit is mV
	iReal_Vref2V = GetVref();

//	for( iloop=0; iloop<=(16/ad_test_times); iloop++ )
//		ADC_detect(Vref2, AIN_GND, Conv256CLK, ADC_Single);
//-----------------------------------
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt

//>>>>>>AD conversion times: ADC_ConvCode(faster) < ADC_ConvVolt,(MQ6812 has auto calibration function)
//......................................................................................................
//------ADC_ConvVolt(,,,):AD conversion result (unit: mV)
//		ADC_VOLTAGE   = ADC_ConvVolt(Vref2, AIN7, Conv128CLK, ADC_Single);
//......................................................................................................
//------ADC_ConvCode(,,,):AD conversion result code
		ADC_Code_READ = ADC_ConvCode(Vref2, AIN7, Conv256CLK, ADC_Single);
		//.........................|......|.....|...........| ADC_Single, ADC_Repeat
		//.........................|......|.....| Conv32CLK, Conv64CLK, Conv128CLK, Conv256CLK, Conv512CLK, Conv1024CLK
		//.........................|......|.....| (*conversion times must be between 12.8 us to 128 us)
		//.........................|......|.....| fcgck=16M... Conv256CLK(16us) ~ Conv1024CLK( 64us)
		//.........................|......|.....| fcgck= 8M... Conv128CLK(16us) ~ Conv1024CLK(128us)
		//.........................|......|.....| fcgck= 4M... Conv64CLK (16us) ~ Conv512CLK (128us)
		//.........................|......|.....| fcgck= 2M... Conv32CLK (16us) ~ Conv256CLK (128us)
		//.........................|......| AIN0~AIN8, VDD4_1, AIN_GND
		//.........................| Vref2, Vref3, Vref4, VDDVref, EXTVref
		// the following list is AD conversion time reference value, FCGCK=16MHz,Conv256CLK(16us),Vref=2V
		// ad_test_times--Single(code)--Single(voltage)--Repeat(code)--Repeat(voltage)
		//       1      --  121us     --  156us        --  111us     --  146us
		//       2      --  222us     --  257us        --  150us     --  185us
		//       4      --  380us     --  415us        --  220us     --  255us
		//       8      --  700us     --  735us        --  349us     --  384us
		//      16      -- 1300us     -- 1335us        --  600us     --  635us

		data2Port[0] = ((ADC_Code_READ/100)%100);
		data2Port[1] = ((ADC_Code_READ/  1)%100);
	//	look_data(99); look_data(data2Port[0]); look_data(data2Port[1]);
		look_data(data2Port[0]); look_data(data2Port[1]);
//		ADC_VOLTAGE  = ((ulong)ADC_Code_READ * 2000) / 1024;	// only for setting ADC reference voltage to internal 2V
//		data2Port[0] = ((ADC_VOLTAGE/100)%100);
//		data2Port[1] = ((ADC_VOLTAGE/  1)%100);
//		look_data(data2Port[0]); look_data(data2Port[1]);

//		data2Port[0] = ((iReal_Vref2V/100)%100);
//		data2Port[1] = ((iReal_Vref2V/  1)%100);
//		look_data(88); look_data(data2Port[0]); look_data(data2Port[1]);
//		data2Port[0] = ((adc_GND/100)%100);
//		data2Port[1] = ((adc_GND/  1)%100);
//		look_data(0); look_data(data2Port[0]); look_data(data2Port[1]);
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}




//*********************************************************************
// name			: delay_times(uchar tBase, uint x)
// brief		: time delay function
// note			: ==> t_1ms   = 0;
// 			: ==> t_100us = 1;
// 			: ==> t_6u    = 2;	//HIRC: 8MHz, CGCR/4
// 			: ==> t_3u    = 3;	//HIRC:16MHz, CGCR/4
// 			: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;
//	uchar cgcrF[4]={ 2, 4,  8, 1 };		// HIRC =>  8MHz
	uchar cgcrF[4]={ 4, 8, 16, 2 };		// HIRC => 16MHz

	cgcrT = cgcrF[CGCR.byte];			// 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
	switch(tBase){
		case 0:		// t_1ms
			cgcrT *= 110;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 1:		// t_100us
			cgcrT *= 11;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 2:		// t_6u				// HIRC: 8MHz, CGCR/4
			for(; x>0; x--){}
			break;
		case 3:		// t_3u				// HIRC:16MHz, CGCR/4
			for(; x>0; x--){}
			break;
	}
	WDCDR.byte=0x4e; 			// clear wdt
}


//*********************************************************************
// name			: look_data()
// brief		: IO output data by IO_i2c
// note			:
//	//-- Define IO port --//
//	#define	look_SDA				P9DR.bit.b0
//	#define	look_SCL				P9DR.bit.b1
//*********************************************************************
void look_data(uchar data)
{
	uchar iloop, x, z=10;

//	start condition......
	look_SDA = 1;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	sent byte data......
	for( iloop=0; iloop<8; iloop++ )
	{
		look_SDA = data >> 7;
		data     = data << 1;
						for(x=z; x>0; x--){}
		look_SCL = 1;	for(x=z; x>0; x--){}
		look_SCL = 0;	for(x=z; x>0; x--){}
	}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	stop condition......
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 1;		for(x=z; x>0; x--){}
}



